#!/bin/sh

echo start change ftp path

DIR=`dirname "${0}"`

FTP_PATH=`echo $1 | sed 's/\//\\\\\//g'`

echo arg1    : $1
echo FTP_PATH: ${FTP_PATH}

ROOTFS_RO=`"${DIR}/check_rootfs_ro.sh"`

# rootfs read write
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o rw,remount /
fi

cat vsftpd.conf.template | sed "s/__LOCAL_ROOT__/${FTP_PATH}/g" > /etc/vsftpd.conf

# rootfs read only
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o ro,remount /
fi

/etc/init.d/vsftpd restart

echo finish change ftp path

# success
exit 0
